% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_utilities.R
\name{compare_mcc}
\alias{compare_mcc}
\title{Compare \code{mcc} objects}
\usage{
compare_mcc(x, y, tolerance = 1e-06)
}
\arguments{
\item{x}{First \code{mcc} object}

\item{y}{Second \code{mcc} object}

\item{tolerance}{Numeric tolerance for comparing MCC values (default: 1e-6)}
}
\value{
A list summarizing the comparison
}
\description{
Compares two \code{mcc} objects and returns a summary of differences.
Useful for comparing results from different methods or parameter settings.
}
\examples{
# Create sample data
library(dplyr)
df <- data.frame(
  id = c(1, 2, 3, 4, 4, 4, 4, 5, 5),
  time = c(8, 1, 5, 2, 6, 7, 8, 3, 3),
  cause = c(0, 0, 2, 1, 1, 1, 0, 1, 2)
) |>
  arrange(id, time)

# Calculate MCC using different methods
mcc_eq <- mcc(df, "id", "time", "cause", method = "equation")
mcc_sci <- mcc(df, "id", "time", "cause", method = "sci")

# Compare the results
comparison <- compare_mcc(mcc_eq, mcc_sci)
print(comparison)

# Clean up
rm(df, mcc_eq, mcc_sci, comparison)

}
