% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_S3_methods.R
\name{residuals.mcglm}
\alias{residuals.mcglm}
\title{Residuals for mcglm Objects}
\usage{
\method{residuals}{mcglm}(object, type = c("raw", "pearson", "standardized"), ...)
}
\arguments{
\item{object}{An object of class \code{mcglm}.}

\item{type}{A character string specifying the type of residuals to be returned.
Options are:
\describe{
  \item{\code{"raw"}}{Raw residuals, defined as observed minus fitted values.}
  \item{\code{"pearson"}}{Pearson residuals, scaled by the marginal standard deviation.}
  \item{\code{"standardized"}}{Standardized residuals, obtained using the inverse covariance matrix.}
}}

\item{...}{Further arguments passed to or from other methods. Currently ignored.}
}
\value{
A numeric matrix of class \code{Matrix} with dimensions
\eqn{n \times r}, where \eqn{n} is the number of observations and
\eqn{r} is the number of response variables.
}
\description{
Computes residuals for a fitted \code{mcglm} object. Different types
of residuals can be extracted, depending on the specified argument
\code{type}.
}
\seealso{
\code{\link[stats]{residuals}},
\code{\link{fitted.mcglm}}
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
