% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_offset.R
\name{mc_offset}
\alias{mc_offset}
\title{Create a model component object for an offset, i.e. fixed, non-parametrised term in the linear predictor}
\usage{
mc_offset(formula, value = NULL, name = "")
}
\arguments{
\item{formula}{model formula.}

\item{value}{alternative specification of an offset as a single scalar
value that is the same for each data unit.}

\item{name}{the name of the model component. This name is used in the output of the MCMC simulation
function \code{\link{MCMCsim}}. By default the name will be 'mc_offset' with the number of the model term attached.}
}
\value{
An model component object with data and methods needed for dealing with an offset term
 in model estimation, and prior and posterior prediction,
 intended for internal use by other package functions.
}
\description{
This function is intended to be used on the right hand side of the \code{formula} argument to
\code{\link{create_sampler}} or \code{\link{generate_data}}.
}
