% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memoria.R
\docType{data}
\name{palaeodataMemory}
\alias{palaeodataMemory}
\title{Output of \code{\link{computeMemory}}}
\format{
List with five slots.
}
\usage{
data(palaeodataMemory)
}
\description{
List containing the output of \code{\link{computeMemory}} applied to \code{\link{palaeodataLagged}}. Its slots are:
}
\details{
\itemize{
 \item \code{response} character, response variable name.
 \item \code{drivers} character vector, driver variable names.
 \item \code{memory} dataframe with five columns:
    \itemize{
      \item \code{variable} character, names of the different variables used to model ecological memory.
      \item \code{lag} numeric, time lag values.
      \item \code{median} numeric, median importance across \code{repetitions} of the given \code{variable} according to Random Forest.
      \item \code{sd} numeric, standard deviation of the importance values of the given \code{variable} across \code{repetitions}.
      \item \code{min} and \code{max} numeric, percentiles 0.05 and 0.95 of importance values of the given \code{variable} across \code{repetitions}.
    }
 \item \code{R2} vector, values of pseudo R-squared value obtained for the Random Forest model fitted on each repetition. Pseudo R-squared is the Pearson correlation between the observed and predicted data.
 \item \code{prediction} dataframe, with the same columns as the dataframe in the slot \code{memory}, with the median and confidence intervals of the predictions of all random forest models fitted.
}
}
\seealso{
Other example_data: 
\code{\link{climate}},
\code{\link{palaeodata}},
\code{\link{palaeodataLagged}},
\code{\link{pollen}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
\concept{example_data}
\keyword{datasets}
