% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize_cyclic_loess}
\alias{normalize_cyclic_loess}
\title{Normalize intensities across samples using cyclic LOESS normalization}
\usage{
normalize_cyclic_loess(
  data,
  n_iter = 3,
  fixed_iter = TRUE,
  loess_span = 0.7,
  level = 0.95,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{n_iter}{The number of iterations to perform. If \code{fixed_iter = TRUE} exactly \code{n_iter} will be performed. If \code{fixed_iter = FALSE} a maximum of \code{n_iter} will be performed and the algorithm will stop whether convergence is reached or not.}

\item{fixed_iter}{Should a fixed number of iterations be performed?}

\item{loess_span}{The span of the LOESS fit. A larger span produces a smoother line.}

\item{level}{The confidence level for the convergence criterion. Note that a a larger confidence level produces larger confidence intervals and therefore the algorithm stops earlier.}

\item{verbose}{\code{TRUE} or \code{FALSE}. Should messages be printed to the console?}

\item{...}{Arguments passed onto \code{\link[stats]{loess}}. For example, \verb{degree = 1, family = "symmetric", iterations = 4, surface = "direct"} produces a LOWESS fit.}
}
\value{
A tibble with intensities normalized across samples.
}
\description{
The steps the algorithm takes are the following:

\enumerate{
\item log2 transform the intensities
\item Choose 2 samples to generate an \href{https://en.wikipedia.org/wiki/MA_plot}{MA-plot} from
\item Fit a LOESS curve
\item Subtract half of the difference between the predicted value and the true value from the intensity of sample 1 and add the same amount to the intensity of Sample 2
\item Repeat for all unique combinations of samples
\item Repeat all steps until the model converges or \code{n_iter} is reached.
}

Convergence is assumed if the confidence intervals of all LOESS smooths include the 0 line. If \code{fixed_iter = TRUE}, the algorithm will perform exactly \code{n_iter} iterations.
If \code{fixed_iter = FALSE}, the algorithm will perform a maximum of \code{n_iter} iterations.

See the reference section for details.
}
\examples{
toy_metaboscape \%>\%
  impute_lod() \%>\%
  normalize_cyclic_loess()
}
\references{
\itemize{
\item B. M. Bolstad, R. A. Irizarry, M. Åstrand, T. P. Speed, \emph{Bioinformatics} \strong{2003}, \emph{19}, 185–193, DOI 10.1093/bioinformatics/19.2.185.
\item Karla Ballman, Diane Grill, Ann Oberg, Terry Therneau, “Faster cyclic loess: normalizing DNA arrays via linear models” can be found under https://www.mayo.edu/research/documents/biostat-68pdf/doc-10027897, 2004.
\item K. V. Ballman, D. E. Grill, A. L. Oberg, T. M. Therneau, \emph{Bioinformatics} \strong{2004}, \emph{20}, 2778–2786, DOI 10.1093/bioinformatics/bth327.
}
}
