% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\name{scale_center}
\alias{scale_center}
\title{Center intensities of features around zero}
\usage{
scale_center(data)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}
}
\value{
A tibble with intensities scaled around zero.
}
\description{
Centers the intensities of all features around zero using

\deqn{\widetilde{x}_{ij}=x_{ij}-\overline{x}_{i}}

where \eqn{\widetilde{x}_{ij}} is the intensity of sample \eqn{j}, feature \eqn{i} after scaling,
\eqn{x_{ij}} is the intensity of sample \eqn{j}, feature \eqn{i} before scaling and \eqn{\overline{x}_{i}} is the mean of intensities of feature \eqn{i} across all samples.
In other words, it subtracts the mean intensity of a feature across samples from the intensities of that feature in each sample.
For more information, see the reference section.
}
\examples{
toy_metaboscape \%>\%
  scale_center()
}
\references{
\itemize{
\item R. A. Van Den Berg, H. C. Hoefsloot, J. A. Westerhuis, A. K. Smilde, M. J. Van Der Werf, \emph{BMC Genomics} \strong{2006}, \emph{7}, 142, DOI 10.1186/1471-2164-7-142.
}
}
