% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSuff.R
\name{getSuff}
\alias{getSuff}
\title{Obtain 'suffStat' for conditional independence testing}
\usage{
getSuff(
  X,
  test = c("gaussCItest", "gaussMItest", "disCItest", "disMItest", "disCItwd",
    "mixCItest", "mixMItest", "flexMItest", "flexCItest"),
  adaptDF = NULL,
  nlev = NULL
)
}
\arguments{
\item{X}{For 'test=xxxCItest': a data.frame or matrix;
for 'test=xxxMItest': an object of class \code{mice::\link[mice:mids-class]{mids}},
or a list of data.frames containing the multiply imputed data sets.}

\item{test}{one of \code{\link[pcalg:condIndFisherZ]{pcalg::gaussCItest()}}, \code{\link[=gaussMItest]{gaussMItest()}}, \code{\link[pcalg:disCItest]{pcalg::disCItest()}},
\code{\link[=disMItest]{disMItest()}}, \code{\link[=mixCItest]{mixCItest()}}, \code{\link[=mixMItest]{mixMItest()}}, \code{\link[=flexCItest]{flexCItest()}},
\code{\link[=flexMItest]{flexMItest()}}.}

\item{adaptDF}{for discrete variables: logical specifying if the degrees of freedom
should be lowered by one for each zero count. The value for the degrees of freedom
cannot go below 1.}

\item{nlev}{(Optional) for discrete variables: vector with numbers of levels for each
variable in the data.}
}
\value{
An R object that can be used as input to the specified conditional independence test:
}
\description{
A convenience function for transforming a multiply imputed data set into the 'suffStat' required
by \code{\link[pcalg:condIndFisherZ]{pcalg::gaussCItest()}}, \code{\link[pcalg:disCItest]{pcalg::disCItest()}}, \code{\link[=mixCItest]{mixCItest()}}, \code{\link[=flexCItest]{flexCItest()}}, \code{\link[=gaussMItest]{gaussMItest()}},
\code{\link[=disMItest]{disMItest()}}, \code{\link[=mixMItest]{mixMItest()}} and \code{\link[=flexMItest]{flexMItest()}}.
}
\examples{

# Example 1: continuous variables, no missing values =====================
data(windspeed)
dat1 <- as.matrix(windspeed)

## analyse data
gaussCItest(1, 2, NULL, suffStat = getSuff(windspeed, test = "gaussCItest"))
mixCItest(1, 2, NULL, suffStat = windspeed)

## Example 2: continuous variables, multiple imputation ===================
dat2 <- mice::ampute(windspeed)$amp

## delete some observations
set.seed(123)

## Impute missing values under normal model
imp2 <- mice(dat2, method = "norm", printFlag = FALSE)

## analyse imputed data
gaussMItest(1, 2, c(4,5), suffStat = getSuff(imp2, test="gaussMItest"))
mixMItest(1, 2, c(4,5), suffStat = getSuff(imp2, test="mixMItest"))
mixMItest(1, 2, c(4,5), suffStat = mice::complete(imp2, action="all"))
flexMItest(1, 2, c(4,5), suffStat = getSuff(imp2, test="flexMItest"))

## Example 3: discrete variables, multiple imputation =====================
## simulate factor variables
n <- 200
set.seed(789)
x <- factor(sample(0:2, n, TRUE)) # factor, 3 levels
y <- factor(sample(0:3, n, TRUE)) # factor, 4 levels
z <- factor(sample(0:1, n, TRUE)) # factor, 2 levels
dat3 <- data.frame(x,y,z)

## delete some observations of z
dat3[sample(1:n, 40), 3] <- NA

## impute missing values under saturated model
form <- make.formulas.saturated(dat3)
imp3 <- mice::mice(dat3, method = "logreg", formulas = form, printFlag = FALSE)

## analyse imputed data
disMItest(1, 3, 2, suffStat = getSuff(imp3, test="disMItest"))
disMItest(1, 3, 2, suffStat = mice::complete(imp3, action = "all"))
mixMItest(1, 3, 2, suffStat = getSuff(imp3, test="mixMItest"))
mixMItest(1, 3, 2, suffStat = mice::complete(imp3, action = "all"))
flexMItest(1, 3, 2, suffStat = getSuff(imp3, test="flexMItest"))

# Example 4: mixed variables, multiple imputation =========================
dat4 <- toenail2[1:400, ]
set.seed(123)
dat4[sample(400, 20), 2] <- NA
dat4[sample(400, 30), 4] <- NA

## impute missing values using random forests
if (requireNamespace("ranger", quietly = TRUE)) {
imp4 <- mice(dat4, method="rf", m = 3, printFlag = FALSE)
mixMItest(2, 3, 5, suffStat = getSuff(imp4, test="mixMItest"))
mixMItest(2, 3, 5, suffStat = mice::complete(imp4, action="all"))
flexMItest(2, 3, 5, suffStat = getSuff(imp4, test="flexMItest"))
}

}
