% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotLDA}
\alias{plotLDA}
\title{plot LEfSe results from ldamarker function}
\usage{
plotLDA(
  x,
  group,
  lda = 2,
  pvalue = 0.05,
  padj = NULL,
  color = NULL,
  fontsize.x = 4,
  fontsize.y = 5
)
}
\arguments{
\item{x}{LEfse results from ldamarker}

\item{group}{a vector include two character to show the group comparsion}

\item{lda}{LDA threshold for significant biomarker}

\item{pvalue}{pvalue threshold for significant results}

\item{padj}{adjust p value threshold for significant results}

\item{color}{A vector of character use specifying the color}

\item{fontsize.x}{the size of x axis label}

\item{fontsize.y}{the size of y axis label}
}
\value{
ggplot2 object
}
\description{
plot LEfSe results from ldamarker function
}
\examples{
\donttest{
data("Physeq")
res <- ldamarker(physeq,group="group")
plotLDA(res,group=c("A","B"),lda=5,pvalue=0.05)
}
}
\author{
Kai Guo
}
