% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_mid.R
\name{summary.mid}
\alias{summary.mid}
\title{Summarize MID Models}
\usage{
\method{summary}{mid}(
  object,
  diagnosis = FALSE,
  digits = max(3L, getOption("digits") - 2L),
  ...
)
}
\arguments{
\item{object}{a "mid" object to be summarized.}

\item{diagnosis}{logical. If \code{TRUE}, the diagnosis plot is displayed. Defaults to \code{FALSE}.}

\item{digits}{the number of significant digits for printing numeric values.}

\item{...}{arguments to be passed to \code{graphics::panel.smooth()} for the diagnosis plot.}
}
\value{
\code{summary.mid()} returns the original "mid" object invisibly.
}
\description{
For "mid" objects, an S3 method of \code{summary()} prints a comprehensive summary of a fitted MID model.
}
\details{
The S3 method \code{summary.mid()} generates a comprehensive overview of the fitted MID model.
The output includes:
\itemize{
  \item \strong{Call}: the function call used to fit the MID model.
  \item \strong{Link}: name of the link function used to fit the MID model, if applicable.
  \item \strong{Uninterpreted Variation Ratio}: proportion of target model variance not explained by MID model.
  \item \strong{Residuals}: five-number summary of (working) residuals.
  \item \strong{Encoding}: summary of encoding schemes per variable.
  \item \strong{Diagnosis}: residuals vs fitted values plot (displayed only when \code{diagnosis = TRUE}).
}
}
\examples{
# Summarize a fitted MID model
data(cars, package = "datasets")
mid <- interpret(dist ~ speed, cars)
summary(mid)
}
\seealso{
\code{\link{interpret}}, \code{\link{print.mid}}
}
