% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf-stream.R
\name{pdf_circle}
\alias{pdf_circle}
\title{Add a circle to a PDF doc}
\usage{
pdf_circle(doc, x, y, r, ..., gp = pgpar(), tf = NULL, clip = NULL)
}
\arguments{
\item{doc}{A \code{pdf_doc} object created by \code{\link{create_pdf}()}}

\item{x, y, r}{position of centre and radius of circle (Length = 1 or n)}

\item{...}{further arguments to be added to \code{gp}}

\item{gp}{A named list \code{gp} object created by \code{\link{pgpar}()}}

\item{tf}{either a single transform (\code{tf_translate()}, \code{tf_scale()},
\code{tf_rotate()}), or a list of these transforms.  Default: NULL,
no local transformation applied (global transformations still apply)}

\item{clip}{either a single clip (\code{clip_rect()}, \code{clip_polygon()}),
or a list of these clips.  Default: NULL,
no local clipping applied (global clipping still applicable)}
}
\value{
\code{pdf_doc}
}
\description{
Add a circle to a PDF doc
}
\examples{
doc <- create_pdf() |>
   pdf_circle(x = 200, y = 200, r = 50)
}
\seealso{
Other object creation functions: 
\code{\link{pdf_bezier}()},
\code{\link{pdf_image}()},
\code{\link{pdf_line}()},
\code{\link{pdf_polygon}()},
\code{\link{pdf_polyline}()},
\code{\link{pdf_rect}()},
\code{\link{pdf_text}()}
}
\concept{object creation functions}
