% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_methods.R
\name{mizerERepro}
\alias{mizerERepro}
\title{Get energy rate available for reproduction needed to project standard mizer
model}
\usage{
mizerERepro(params, n, n_pp, n_other, t, e, ...)
}
\arguments{
\item{params}{A \linkS4class{MizerParams} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{t}{The time for which to do the calculation (Not used by standard
mizer rate functions but useful for extensions with time-dependent
parameters.)}

\item{e}{A two dimensional array (species x size) holding the energy available
for reproduction and growth as calculated by \code{\link[=mizerEReproAndGrowth]{mizerEReproAndGrowth()}}.}

\item{...}{Unused}
}
\value{
A two dimensional array (species x size) holding
\deqn{\psi_i(w)E_{r.i}(w)}
where \eqn{E_{r.i}(w)} is the rate at which energy becomes available for
growth and reproduction, calculated with \code{\link[=mizerEReproAndGrowth]{mizerEReproAndGrowth()}},
and \eqn{\psi_i(w)} is the proportion of this energy that is used for
reproduction. This proportion is taken from the \code{params} object and is
set with \code{\link[=setReproduction]{setReproduction()}}.
}
\description{
Calculates the energy rate (grams/year) available for reproduction after
growth and metabolism have been accounted for.
You would not usually call this
function directly but instead use \code{\link[=getERepro]{getERepro()}}, which then calls this
function unless an alternative function has been registered, see below.
}
\section{Your own reproduction rate function}{

By default \code{\link[=getERepro]{getERepro()}} calls \code{\link[=mizerERepro]{mizerERepro()}}. However you can
replace this with your own alternative reproduction rate function. If
your function is called \code{"myERepro"} then you register it in a MizerParams
object \code{params} with

\if{html}{\out{<div class="sourceCode">}}\preformatted{params <- setRateFunction(params, "ERepro", "myERepro")
}\if{html}{\out{</div>}}

Your function will then be called instead of \code{\link[=mizerERepro]{mizerERepro()}}, with the
same arguments.
}

\seealso{
Other mizer rate functions: 
\code{\link{mizerEGrowth}()},
\code{\link{mizerEReproAndGrowth}()},
\code{\link{mizerEncounter}()},
\code{\link{mizerFMort}()},
\code{\link{mizerFMortGear}()},
\code{\link{mizerFeedingLevel}()},
\code{\link{mizerMort}()},
\code{\link{mizerPredMort}()},
\code{\link{mizerPredRate}()},
\code{\link{mizerRDI}()},
\code{\link{mizerRates}()},
\code{\link{mizerResourceMort}()}
}
\concept{mizer rate functions}
