% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpFDATsfeatures.R
\name{mlr_pipeops_fda.tsfeats}
\alias{mlr_pipeops_fda.tsfeats}
\alias{PipeOpFDATsfeatures}
\title{Time Series Feature Extraction}
\description{
This \code{PipeOp} extracts time series features from functional columns.

For more details, see \code{\link[tsfeatures:tsfeatures]{tsfeatures::tsfeatures()}}, which is called internally.
}
\section{Parameters}{

The parameters are the parameters inherited from \code{\link[mlr3pipelines:PipeOpTaskPreprocSimple]{PipeOpTaskPreprocSimple}},
as well as the following parameters:
\itemize{
\item \code{features} :: \code{character()}\cr
Function names which return numeric vectors of features.
All features returned by these functions must be named if they return more than one feature.
Default is \code{c("frequency", "stl_features", "entropy", "acf_features")}.
\item \code{scale} :: \code{logical(1)}\cr
If \code{TRUE}, data is scaled to mean 0 and sd 1 before features are computed. Default is \code{TRUE}.
\item \code{trim} :: \code{logical(1)}\cr
If \code{TRUE}, data is trimmed by \code{trim_amount} before features are computed.
Values larger than \code{trim_amount} in absolute value are set to \code{NA}. Default is \code{FALSE}.
\item \code{trim_amount} :: \code{numeric(1)}\cr
Default level of trimming. Default is \code{0.1}.
\item \code{parallel} :: \code{logical(1)}\cr
If \code{TRUE}, the features are computed in parallel. Default is \code{FALSE}.
\item \code{multiprocess} :: \code{any}\cr
The function from the future package to use for parallel processing. Default is \code{\link[future:multisession]{future::multisession()}}.
\item \code{na.action} :: \code{any}\cr
A function to handle missing values. Default is \code{\link[stats:na.fail]{stats::na.pass()}}.
}
}

\section{Naming}{

The new names generally append a \verb{_\{feature\}} to the corresponding column name.
If a column was called \code{"x"} and the feature is \code{"trend"}, the corresponding new column will
be called \code{"x_trend"}.
}

\examples{
task = tsk("fuel")
po_tsfeats = po("fda.tsfeats")
task_tsfeats = po_tsfeats$train(list(task))[[1L]]
task_tsfeats$data()
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}} -> \code{\link[mlr3pipelines:PipeOpTaskPreprocSimple]{mlr3pipelines::PipeOpTaskPreprocSimple}} -> \code{PipeOpFDATsfeatures}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpFDATsfeatures-new}{\code{PipeOpFDATsfeatures$new()}}
\item \href{#method-PipeOpFDATsfeatures-clone}{\code{PipeOpFDATsfeatures$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDATsfeatures-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDATsfeatures-new}{}}}
\subsection{Method \code{new()}}{
Initializes a new instance of this Class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDATsfeatures$new(id = "fda.tsfeats", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier of resulting object, default is \code{"fda.tsfeats"}.}

\item{\code{param_vals}}{(named \code{list()})\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would
otherwise be set during construction. Default \code{list()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDATsfeatures-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDATsfeatures-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDATsfeatures$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
