% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embedded_ensemble_fselect.R
\name{embedded_ensemble_fselect}
\alias{embedded_ensemble_fselect}
\title{Embedded Ensemble Feature Selection}
\source{
Meinshausen, Nicolai, Buhlmann, Peter (2010).
\dQuote{Stability Selection.}
\emph{Journal of the Royal Statistical Society Series B: Statistical Methodology}, \bold{72}(4), 417--473.
ISSN 1369-7412, \doi{10.1111/J.1467-9868.2010.00740.X}, 0809.2932.

Hedou, Julien, Maric, Ivana, Bellan, Gregoire, Einhaus, Jakob, Gaudilliere, K. D, Ladant, Xavier F, Verdonk, Franck, Stelzer, A. I, Feyaerts, Dorien, Tsai, S. A, Ganio, A. E, Sabayev, Maximilian, Gillard, Joshua, Amar, Jonas, Cambriel, Amelie, Oskotsky, T. T, Roldan, Alennie, Golob, L. J, Sirota, Marina, Bonham, A. T, Sato, Masaki, Diop, Maigane, Durand, Xavier, Angst, S. M, Stevenson, K. D, Aghaeepour, Nima, Montanari, Andrea, Gaudilliere, Brice (2024).
\dQuote{Discovery of sparse, reliable omic biomarkers with Stabl.}
\emph{Nature Biotechnology 2024}, 1--13.
ISSN 1546-1696, \doi{10.1038/s41587-023-02033-x}, \url{https://www.nature.com/articles/s41587-023-02033-x}.
}
\usage{
embedded_ensemble_fselect(
  task,
  learners,
  init_resampling,
  measure,
  store_benchmark_result = TRUE
)
}
\arguments{
\item{task}{(\link[mlr3:Task]{mlr3::Task})\cr
Task to operate on.}

\item{learners}{(list of \link[mlr3:Learner]{mlr3::Learner})\cr
The learners to be used for feature selection.
All learners must have the \code{selected_features} property, i.e. implement
embedded feature selection (e.g. regularized models).}

\item{init_resampling}{(\link[mlr3:Resampling]{mlr3::Resampling})\cr
The initial resampling strategy of the data, from which each train set
will be passed on to the learners and each test set will be used for
prediction.
Can only be \link[mlr3:mlr_resamplings_subsampling]{mlr3::ResamplingSubsampling} or \link[mlr3:mlr_resamplings_bootstrap]{mlr3::ResamplingBootstrap}.}

\item{measure}{(\link[mlr3:Measure]{mlr3::Measure})\cr
The measure used to score each learner on the test sets generated by
\code{init_resampling}.
If \code{NULL}, default measure is used.}

\item{store_benchmark_result}{(\code{logical(1)})\cr
Whether to store the benchmark result in \link{EnsembleFSResult} or not.}
}
\value{
an \link{EnsembleFSResult} object.
}
\description{
Ensemble feature selection using multiple learners.
The ensemble feature selection method is designed to identify the most predictive features from a given dataset by leveraging multiple machine learning models and resampling techniques.
Returns an \link{EnsembleFSResult}.
}
\details{
The method begins by applying an initial resampling technique specified by the user, to create \strong{multiple subsamples} from the original dataset (train/test splits).
This resampling process helps in generating diverse subsets of data for robust feature selection.

For each subsample (train set) generated in the previous step, the method applies learners
that support \strong{embedded feature selection}.
These learners are then scored on their ability to predict on the resampled
test sets, storing the selected features during training, for each
combination of subsample and learner.

Results are stored in an \link{EnsembleFSResult}.
}
\examples{
\donttest{
  eefsr = embedded_ensemble_fselect(
    task = tsk("sonar"),
    learners = lrns(c("classif.rpart", "classif.featureless")),
    init_resampling = rsmp("subsampling", repeats = 5),
    measure = msr("classif.ce")
  )
  eefsr
}
}
