% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_MLmodels.R
\name{train_xgb}
\alias{train_xgb}
\title{Train XGBoost model}
\usage{
train_xgb(data, formula, nrounds = 100, max_depth = 4, learning_rate = 0.1)
}
\arguments{
\item{data}{A data frame with the training data.}

\item{formula}{A formula defining the model structure.}

\item{nrounds}{Number of boosting iterations.}

\item{max_depth}{Maximum tree depth.}

\item{learning_rate}{Learning rate for boosting.}
}
\value{
A trained xgboost model object.
}
\description{
Train XGBoost model
}
\details{
Trains an XGBoost regression model.
}
\examples{
\donttest{
# Load required package
library(xgboost)

# Use built-in dataset
data(mtcars)

# Define regression formula
xgb_formula <- mpg ~ cyl + disp + hp + wt

# Train XGBoost model
xgb_model <- train_xgb(data = mtcars, formula = xgb_formula, nrounds = 50)

# Print model summary
print(xgb_model)
}
}
