% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFI3d.R
\name{RFI3d}
\alias{RFI3d}
\title{Plot 3D and 2D areas of a mesh used to calculate relief index (HTML widget)}
\usage{
RFI3d(
  RFI_File,
  displacement = -1.9,
  SurfaceColor = "gray",
  FootColor = "red",
  FootPts = FALSE,
  FootPtsColor = "black",
  Opacity = 1,
  legend = TRUE,
  main = "",
  cex = 1,
  widget_size_px = 768,
  scene_zoom = 1.5,
  leftOffset = 0,
  fieldofview = 0,
  title_font_size_px = 30,
  title_font_family =
    "system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, sans-serif",
  legend_magnify = 1,
  fileName = NA,
  binary = FALSE
)
}
\arguments{
\item{RFI_File}{An object that stores the output of the RFI function}

\item{displacement}{Numeric that moves the surface footprint some proportion
of the height of the mesh. 0 is vertical center; negative values displace
the footprint downward. Default -1.9.}

\item{SurfaceColor}{Color for the 3D surface mesh}

\item{FootColor}{Color for the 2D surface footprint}

\item{FootPts}{Logical; if TRUE, plot the flattened points used for the footprint}

\item{FootPtsColor}{Color of plotted footprint points when \code{FootPts = TRUE}}

\item{Opacity}{Numeric from 0 to 1 controlling the opacity of the 3D surface}

\item{legend}{Logical; draw a legend (right side of the widget)}

\item{main}{Plot title}

\item{cex}{Base scaling for legend/ticks (relative multiplier)}

\item{widget_size_px}{Square widget size in pixels (default 768)}

\item{scene_zoom}{Initial zoom for the 3d scene (default 1.5)}

\item{leftOffset}{Horizontal camera nudge (-1..1 recommended)}

\item{fieldofview}{Field of view in degrees (0 = isometric)}

\item{title_font_size_px}{Title font size in pixels (default 30)}

\item{title_font_family}{CSS font-family list for the title}

\item{legend_magnify}{Additional scale factor for the legend text}

\item{fileName}{Optional file base name to save a colored *.ply (no legend)}

\item{binary}{Binary PLY if TRUE (smaller files)}
}
\description{
Renders a three-dimensional model of the mesh surface and a footprint of the
two-dimensional area side-by-side for visual comparison. The \code{RFI()} function
must be performed prior to using \code{RFI3d()}.
}
\details{
This function helps visualize the 3D surface area (numerator) and the 2D
projected area (denominator) that comprise the relief index, by displaying
both at once. Adjust \code{Opacity} to make the footprint more visible through
the surface. The footprint plane can be moved along Z via \code{displacement}.

The plotting window is an HTML widget. The legend is rendered in HTML/CSS
and aligned vertically at the right of the scene.
}
\examples{
if(interactive()){
  rfi <- RFI(Tooth, alpha = 0.5)
  RFI3d(rfi)
}
}
