% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mongolstats-package.R
\docType{package}
\name{mongolstats-package}
\alias{mongolstats}
\alias{mongolstats-package}
\title{mongolstats: Mongolian NSO PXWeb Data and Boundaries}
\description{
A tidyverse-friendly client for the National Statistics Office of Mongolia
PXWeb API (data.1212.mn) with helpers to discover tables, variables, and fetch
statistical data. Also includes utilities to retrieve Mongolia administrative
boundaries (ADM0-ADM2) as 'sf' objects from open sources for mapping and
spatial analysis.
}
\section{Main Functions}{

\describe{
\item{nso_data}{Fetch statistical data from a table}
\item{nso_itms, nso_tables}{List available tables}
\item{nso_itms_search}{Search tables by keyword}
\item{mn_boundaries}{Get administrative boundaries}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://temuulene.github.io/mongolstats/}
  \item \url{https://data.1212.mn/pxweb/}
  \item Report bugs at \url{https://github.com/temuulene/mongolstats/issues}
}

}
\author{
\strong{Maintainer}: Temuulen Enebish \email{temuulen@gmail.com} [copyright holder]

}
\keyword{internal}
