% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{nso_package}
\alias{nso_package}
\title{Fetch multiple tables and bind (PXWeb)}
\usage{
nso_package(
  requests,
  labels = c("none", "en", "mn", "both"),
  parallel = getOption("mongolstats.parallel", FALSE),
  value_name = getOption("mongolstats.value_name", "value")
)
}
\arguments{
\item{requests}{A list of records, each with \code{tbl_id} and \code{selections} (named list)}

\item{labels}{Label handling as in \code{nso_data()}}

\item{parallel}{If TRUE, use future.apply to fetch tables in parallel.}

\item{value_name}{Name of the numeric value column in the result (default: "value").}
}
\value{
A tibble combining data from all requested tables, with a \code{tbl_id} column
identifying the source table.
}
\description{
Fetch multiple tables and bind (PXWeb)
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
reqs <- list(
  list(tbl_id = "DT_NSO_0300_001V2", selections = list(Year = "2023"))
)
combined <- nso_package(reqs)
\dontshow{\}) # examplesIf}
}
