% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_inventory.R
\name{filter_inventory}
\alias{filter_inventory}
\title{Filter the inventory of tables}
\usage{
filter_inventory(..., type = c("and", "or"))
}
\arguments{
\item{...}{Keywords or regular expressions used to filter the
\link{table_inventory} data set by the \code{name} column. Alternatively, the first
argument passed to \code{...} can be a data frame containing a column called
name. This feature allows \code{\link[=filter_inventory]{filter_inventory()}} to be called in succession
using the pipe operator.}

\item{type}{Type of filtering performed. If "and", names must match all
expressions passed to \code{...}. If "or", names must match at least one
expression passed to \code{...}.}
}
\value{
A data frame (tibble)
}
\description{
Filter the \link{table_inventory} by keywords to find table identification numbers
quickly.
}
\details{
The mort.soa.org site contains a large number of tables indexed by
identification numbers. The \code{mortSOA} package includes a data set called
\link{table_inventory} that contains all available tables as of
2026-01-24. This function can be used to filter that
table by name using keywords passed to the \code{...} argument. Filtering is
accomplished using \code{\link[=grepl]{grepl()}}, so regular expressions are accepted.

Multiple calls to \code{filter_inventory()} can be chained together using the pipe
operator.
}
\examples{
filter_inventory("2012 IAM", "Female")
# Same result using a regular expression
filter_inventory("2012 IAM.*Female")
# Chained version with type = "or"
filter_inventory("Pri-2012", "Retiree") |>
  filter_inventory("Blue", "White", type = "or")

}
\references{
Society of Actuaries Mortality and Other Rate Tables
\url{https://mort.soa.org}
}
