% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_sim_brownian_motion.R
\name{mt_sim_brownian_motion}
\alias{mt_sim_brownian_motion}
\title{Simulate Brownian motion}
\usage{
mt_sim_brownian_motion(
  t = 1L:10L,
  sigma = 1L,
  tracks = 2L,
  start_location = c(0L, 0L),
  track_id = NULL
)
}
\arguments{
\item{t}{a vector of timestamps, numeric values or times to simulate for. If multiple tracks are created this vector will
be used for all of them, alternatively a list with a vector per track can be provided.}

\item{sigma}{The Brownian motion variance movement rate  \eqn{[\frac{\sigma}{time}]} either as scalar number or a
vector with a number per segment. Not that this argument is the movement rate so the motion variance will be
adjusted for the length of the interval. Alternatively a function that is integrated over time in the simulation
function, this function needs to be vectorized (if needed see \code{\link[base]{Vectorize}}). If a list is provided
one element of the list is taken per track.}

\item{tracks}{Either the number of tracks or a vector containing the names of the tracks.}

\item{start_location}{Either one or a list of start locations, as a vector with two numbers.}

\item{track_id}{The identifier of the track if a single track is requested.}
}
\value{
a move2 object
}
\description{
Creates a \code{move2} object with simulated data following a Brownian motion
}
\details{
Note that when lists are provided as in input the names of these lists are ignored. Individuals are simulated by
order.

If \code{t} is numeric the movement rate (\code{sigma}) is assumed to be expressed per unit \code{t}, if \code{t} is a timestamp or a
date, \code{sigma} is assumed to be expressed per second.
}
\examples{
mt_sim_brownian_motion() |> plot()
mt_sim_brownian_motion(list(1:10, 1:100)) |>
  mt_track_lines() |>
  plot()
mt_sim_brownian_motion(1:200,
  sigma = .25, letters[1:4],
  list(c(0, 0), c(10, 0), c(0, 10), c(10, 10))
) |>
  mt_track_lines() |>
  plot()
}
