% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R, R/documentation.R, R/inputs.R
\name{Checkbox}
\alias{Checkbox}
\alias{Checkbox.shinyInput}
\alias{updateCheckbox.shinyInput}
\title{Checkbox}
\usage{
Checkbox(...)

Checkbox.shinyInput(inputId, ..., value = defaultValue)

updateCheckbox.shinyInput(
  session = shiny::getDefaultReactiveDomain(),
  inputId,
  ...
)
}
\arguments{
\item{...}{Props to pass to the component.}

\item{inputId}{ID of the component.}

\item{value}{Starting value.}

\item{session}{Object passed as the `session` argument to Shiny server.}
}
\value{
Object with \code{shiny.tag} class suitable for use in the UI of a Shiny app.
}
\description{
\url{https://mui.com/material-ui/api/checkbox/}
}
\details{
\itemize{
\item checked \code{bool} \cr Default is - If true, the component is checked.
\item checkedIcon \code{node} \cr Default is CheckBoxIcon / The icon to display when the component is checked.
\item classes \code{object} \cr Default is - Override or extend the styles applied to the component.See CSS classes API below for more details.
\item color \code{'default'| 'primary'| 'secondary'| 'error'| 'info'| 'success'| 'warning'| string} \cr Default is 'primary' The color of the component. It supports both default and custom theme colors, which can be added as shown in the palette customization guide.
\item defaultChecked \code{bool} \cr Default is - The default checked state. Use when the component is not controlled.
\item disabled \code{bool} \cr Default is FALSE If true, the component is disabled.
\item disableRipple \code{bool} \cr Default is FALSE If true, the ripple effect is disabled.
\item icon \code{node} \cr Default is CheckBoxOutlineBlankIcon / The icon to display when the component is unchecked.
\item id \code{string} \cr Default is - The id of the input element.
\item indeterminate \code{bool} \cr Default is FALSE If true, the component appears indeterminate. This does not set the native input element to indeterminate due to inconsistent behavior across browsers. However, we set a data-indeterminate attribute on the input.
\item indeterminateIcon \code{node} \cr Default is IndeterminateCheckBoxIcon / The icon to display when the component is indeterminate.
\item inputProps \code{object} \cr Default is - Attributes applied to the input element.Deprecated Use slotProps.input instead. This prop will be removed in a future major release. See Migrating from deprecated APIs for more details.
\item onChange \code{func} \cr Default is - Callback fired when the state is changed.Signature:function(event: React.ChangeEvent) = voidevent The event source of the callback. You can pull out the new checked state by accessing event.target.checked (boolean).
\item required \code{bool} \cr Default is FALSE If true, the input element is required.
\item size \code{'medium'| 'small'| string} \cr Default is 'medium' The size of the component. small is equivalent to the dense checkbox styling.
\item slotProps \verb{\{ input?: func| object, root?: func| object \}} \cr Default is The props used for each slot inside.
\item slots \verb{\{ input?: elementType, root?: elementType \}} \cr Default is The components used for each slot inside.
\item sx \verb{Array func| object| bool | func| object} \cr Default is - The system prop that allows defining system overrides as well as additional CSS styles.See the \code{sx} page for more details.
\item value \code{any} \cr Default is - The value of the component. The DOM API casts this to a string. The browser uses "on" as the default value.
}
}
