% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_4_rpl_e.R
\name{rpl_e}
\alias{rpl_e}
\title{Step 4: Replaying the experiment with optimal parameters}
\usage{
rpl_e(
  result,
  free_params = NULL,
  data,
  colnames,
  behrule,
  ids = NULL,
  models,
  funcs = NULL,
  priors = NULL,
  settings = NULL,
  ...
)
}
\arguments{
\item{result}{Result from \code{rcv_d} or \code{fit_p}}

\item{free_params}{In order to prevent ambiguity regarding the free parameters, their names 
can be explicitly defined by the user.}

\item{data}{A data frame in which each row represents a single trial,
see \link[multiRL]{data}}

\item{colnames}{Column names in the data frame,
see \link[multiRL]{colnames}}

\item{behrule}{The agent’s implicitly formed internal rule,
see \link[multiRL]{behrule}}

\item{ids}{The Subject ID of the participant whose data needs to be fitted.}

\item{models}{Reinforcement Learning Models}

\item{funcs}{The functions forming the reinforcement learning model,
see \link[multiRL]{funcs}}

\item{priors}{Prior probability density function of the free parameters,
see \link[multiRL]{priors}}

\item{settings}{Other model settings, 
see \link[multiRL]{settings}}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
An S3 object of class \code{multiRL.replay}.
  A \code{List} containing, for each subject and each fitted model, the
  estimated optimal parameters, along with the resulting
  \code{multiRL.model} and \code{multiRL.summary} objects obtained by
  replaying the model with those parameters.
}
\description{
Step 4: Replaying the experiment with optimal parameters
}
\section{Example}{
 
\preformatted{ # info
 data = multiRL::TAB
 colnames = list(
   object = c("L_choice", "R_choice"), 
   reward = c("L_reward", "R_reward"),
   action = "Sub_Choose"
 )
 behrule = list(
   cue = c("A", "B", "C", "D"),
   rsp = c("A", "B", "C", "D")
 )
 
 replay.recovery <- multiRL::rpl_e(
   result = recovery.MLE,
  
   data = data,
   colnames = colnames,
   behrule = behrule,
  
   models = list(multiRL::TD, multiRL::RSTD, multiRL::Utility),
   settings = list(name = c("TD", "RSTD", "Utility")),
  
   omit = c("data", "funcs")
 )

 replay.fitting <- multiRL::rpl_e(
   result = fitting.MLE,
  
   data = data,
   colnames = colnames,
   behrule = behrule,
  
   models = list(multiRL::TD, multiRL::RSTD, multiRL::Utility),
   settings = list(name = c("TD", "RSTD", "Utility")),
  
   omit = c("funcs")
 )
}
}

