% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiRec.R
\name{multiRec}
\alias{multiRec}
\title{Fit the multi-type recurrent event model}
\usage{
multiRec(
  ...,
  data,
  eventVar = "event",
  startTimeVar = "tstart",
  stopTimeVar = "tstop",
  idVar = "id",
  na.action = na.omit,
  link = c("log", "identity", "yj"),
  SANN.init = 0,
  noEvent = c("", NA),
  robust = FALSE,
  method = c("BFGS", "Nelder-Mead", "CG", "SANN"),
  method.seed = NULL,
  hazardPrefix = "nPrior.",
  maxit,
  trace = FALSE,
  fitDetails = FALSE,
  hessian = c("optim", "numDeriv")
)
}
\arguments{
\item{...}{one or more models (see details)}

\item{data}{the dataset}

\item{eventVar}{character, the name of the event variable in the data= dataset}

\item{startTimeVar}{character, the name of the variable that holds the start
time of each interval in the data= dataset}

\item{stopTimeVar}{character, the name of the variable that holds the stop
time of each interval in the data= dataset}

\item{idVar}{character, the name of the id variable which uniquely identifies
individuals in the data= dataset}

\item{na.action}{function, a function which indicates what should happen when
the data contain NAs. The default is na.omit.}

\item{link}{the link used to model the hazard}

\item{SANN.init}{integer, if this is greater than 0 it indicates the number
of simulated annealing iterations used to refine the initial estimate of
the parameters before calling the method specified in method=.}

\item{noEvent}{character, the value(s) of the event variable that indicate
that no event occurred in an interval}

\item{robust}{logical, if TRUE robust standard errors are used}

\item{method}{character, the optimization method see the optim function for
details}

\item{method.seed}{numeric, the seed used}

\item{hazardPrefix}{character, the prefix used to denote prior event
functions in the formulas for the hazard}

\item{maxit}{integer, the maximum number of iteration for the optimization
method. Defaults to 500 for Nelder-Mead, 100 for all other methods.}

\item{trace}{logical, if TRUE additional information is printed by the
algorithm}

\item{fitDetails}{logical, if TRUE the returned fit object contains
additional information used to create fit diagnostics.}

\item{hessian}{character, use the Hessian calculated in optim or calculated
separately in numDeriv::hessian().}
}
\value{
an object of type agMTRE
}
\description{
multi-type events, may be recurrent or terminating
}
\details{
models for the hazard are of the form

lhs ~ rhs

where lhs is one of the possible events and rhs is the usual model right
hand side, with one addition: the pseudo-function "nPrior." can be
used to indicate a dependence of the hazard on prior events. This function
has the form

nPrior.event(~formula, alpha=value)

where
\describe{
 \item{event}{should be replaced by the appropriate event. For example,
 "nPrior.stroke" indicates a dependence of the hazard on the number of
 strokes prior to the current interval}
 \item{formula}{is a possibly empty formula which expresses the possible
 covariate effects on the extent to which prior events impact the hazard. For
 example "nPrior.stroke(~hba1c+sbp)" indicates a dependence on the number of
 prior strokes which may be modulated by HbA1c (variable hba1c) and systolic
 blood pressure (variable sbp)}
 \item{value}{is the power to which the number of prior events should
 be raised. The default is 1, i.e. the hazard depends simply on the number of
 prior events. A value of 0.5 means that the hazard depends on the square
 root of the number of prior events, i.e. that additional events have
 a diminishing effect on the hazard.  Specifying alpha=NA means that
 the power is unknown and should be estimated.}
}

For example a model of myocardial infaction (event='mi') might be

mi ~ bmi + nPrior.mi(alpha=0.5) + nPrior.stroke(~hba1c+sbp)

to indicate that the hazard of mi depends on body mass index (variable bmi),
on the square root of the number of prior MI's and on the number of prior
strokes, modulated by hba1c and systolic blood pressure.
}
\examples{
# Fit a model for the multiRecCVD2 dataset
fit = multiRec(hf   ~ nPrior.afib(~male),
               afib ~ age + nPrior.afib() + nPrior.hf(),
               data=multiRecCVD2,
               idVar='id',
               link='log')

# Fit the model with robust variances
fit = multiRec(hf   ~ nPrior.afib(~male),
               afib ~ age + nPrior.afib() + nPrior.hf(),
               data=multiRecCVD2,
               idVar='id',
               link='log',
               robust = TRUE)   # Request robust (sandwich) variances

# Use a specified power
fit = multiRec(hf   ~ nPrior.afib(~male),
               afib ~ age + nPrior.afib(alpha=0.5) + nPrior.hf(),
               data=multiRecCVD2,
               idVar='id',
               link='log',
               robust = TRUE)

# Display the coefficients
coef(fit)
confint(fit)

# Display intervals with a poor fit
boxplot(resid(fit))
}
