% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messages.R
\name{paste.and}
\alias{paste.and}
\title{Collapse a vector into a string}
\usage{
paste.and(
  x,
  sep = ", ",
  maxItems = 10,
  last = c("\%1$s and \%2$s", "\%1$s, \%2$s and \%3$d more",
    "\%1$s, \%2$s and \%3$d more"),
  quote = NULL
)
}
\arguments{
\item{x}{the vector}

\item{sep}{the separator for all but the last entry}

\item{maxItems}{If there are more than this many items, only the first
maxItems are displayed.}

\item{last}{three sprintf formats (see details)}

\item{quote}{A function used to quote the elements (such as
sQuote or dQuote) or NULL}
}
\value{
a string
}
\description{
Collapses a vector into a comma delimited string with the word 'and'
between the last two entries.
}
\details{
The last= argument contains three sprintf formats. The first is used if
there are fewer than maxItems items, the second if there are maxItems+1
items, the first if there are more than maxItems+1 items.

The arguments are passed as %1$: the string consisting of all items except
the last, %2$ the last item %3$ an integer indicating how many items are not
shown.
}
\examples{
multiRec:::paste.and(1:4)  # "1, 2, 3 and 4"
multiRec:::paste.and(1:16, maxItems=4) # "1, 2, 3, 4 and 12 more"
}
\keyword{internal}
