% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_int.R
\name{calc_POP}
\alias{calc_POP}
\alias{calc_HSP}
\title{Predict the probability of CKMR kinship pairs}
\usage{
calc_POP(t, a, y, N, fec)

calc_HSP(yi, yj, N, fec, Z)
}
\arguments{
\item{t}{Vector, capture year of parent \code{i}}

\item{a}{Vector, age at capture of parent \code{i}}

\item{y}{Vector, birth year of offspring \code{j}}

\item{N}{Abundance of mature spawners. Matrix by \verb{[y, a]}}

\item{fec}{Fecundity schedule of mature spawners. Matrix by \verb{[y, a]}}

\item{yi}{Vector, birth year of sibling \code{i}. Must be older than sibling \code{j}.}

\item{yj}{Vector, birth year of sibling \code{j}.}

\item{Z}{Instantaneous total mortality rate. Matrix by \verb{[y, a]}}
}
\value{
Numeric, vector of probabilities
}
\description{
Calculate the probability of observing a parent-offspring pair (\code{calc_POP}) and
half-sibling pair (\code{calc_HSP}) for closed-kin mark recapture (CKMR) for an age-structured
model.
}
\section{Parent-offspring pairs}{

The parent-offspring probability is calculated from Bravington et al. 2016, eq 3.4:

\deqn{p_{\textrm{POP}} = 2 \times \dfrac{f(y_j,y_j - (t_i - a_i))}{\sum_a f(y_j,a) N(y_j,a)}}

where \eqn{y_j - (t_i - a_i)} is the parental age in year \eqn{y_j}. Scalar 2 accounts for the fact
that the parent could be either a mother or a father.
\code{calc_POP} is vectorized with respect to \code{t}, \code{a}, and \code{y}.
}

\section{Half-sibling pairs}{

The half-sibling probability is calculated from Bravington et al. 2016, eq 3.10, and expanded
by Hillary et al. 2018, Supplement S2.8.1 for age-specific survival and fecundity of the parent:

\deqn{p_{\textrm{HSP}} = 4 \times
\sum_a\left(
\dfrac{N(y_i, a)f(y_i, a)}{\sum_{a'} N(y_i, a')f(y_i,a')}\times
\exp(-\sum_{t = 0}^{y_j - y_i - 1} Z(y_i + t,a + t))\times
\dfrac{f(y_j,a+y_j-y_i)}{\sum_{a'} N(y_j,a')f(y_j,a')}
\right)
}
\itemize{
\item The first ratio is the probability that a fish at age \eqn{a} in year \eqn{y_i} is the parent of \eqn{i}.
\item The exponential term is that fish's survival from year \eqn{y_i} to \eqn{y_j}.
\item The second ratio is the probability that the parent of \eqn{i}, age \eqn{a+y_j-y_i} in year \eqn{y_j}, is the parent of \eqn{j}.
}

The parent is not observed in the HSP, so we sum the probabilities over all potential ages in year \eqn{y_i}.
\code{calc_HSP} is vectorized with respect to \code{yi} and \code{yj}.
}

\references{
Bravington, M.V. et al. 2016. Close-Kin Mark-Recapture. Stat. Sci. 31: 259-274.
\doi{10.1214/16-STS552}

Hillary, R.M. et al. 2018. Genetic relatedness reveals total population size of white sharks in eastern Australia and
New Zealand. Sci. Rep. 8: 2661. \doi{10.1038/s41598-018-20593-w}
}
\seealso{
\code{\link[=like_CKMR]{like_CKMR()}}
}
\author{
Q. Huynh with contribution from Y. Tsukahara (Fisheries Research Institute, Japan)
}
