% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_population.R
\name{calc_phi_project}
\alias{calc_phi_project}
\title{Equilibrium spawners per recruit by projection}
\usage{
calc_phi_project(
  ny,
  nm,
  na,
  nf = 1,
  nr,
  ns = 1,
  F_mfr = array(0, c(nm, nf, nr)),
  sel_mafs = array(1, c(nm, na, nf, ns)),
  fwt_mafs = array(1, c(nm, na, nf, ns)),
  q_fs = matrix(1, nf, ns),
  M_as,
  mov_marrs,
  mat_as,
  fec_as,
  m_spawn = 1,
  m_advanceage = 1,
  delta_s = rep(0, ns),
  natal_rs = matrix(1, nr, ns),
  recdist_rs = matrix(1/nr, nr, ns)
)
}
\arguments{
\item{ny}{Integer, number of years for the projection}

\item{nm}{Integer, number of seasons}

\item{na}{Integer, number of age classes}

\item{nf}{Integer, number of fleets}

\item{nr}{Integer, number of regions}

\item{ns}{Integer, number of stocks}

\item{F_mfr}{Equilibrium fishing mortality (per season). Matrix \verb{[m, f, r]}}

\item{sel_mafs}{Selectivity by season, age, fleet, stock. Array \verb{[m, a, f, s]}}

\item{fwt_mafs}{Fishery weight array by season, age, fleet, stock. Array \verb{[m, a, r, r]}. Can be used
calculate yield per recruit.}

\item{q_fs}{Relative catchability of stock \code{s} for fleet \code{f}. Defaults to 1 if missing. Matrix \verb{[f, s]}}

\item{M_as}{Natural mortality. Matrix \verb{[a, s]}}

\item{mov_marrs}{Movement array \verb{[m, a, r, r, s]}. If missing, uses a diagonal matrix (no movement among areas).}

\item{mat_as}{Maturity at age. Matrix \verb{[a, s]}}

\item{fec_as}{Fecundity at age. Matrix \verb{[a, s]}}

\item{m_spawn}{Integer, season of spawning}

\item{m_advanceage}{Integer, season at which to advance integer year age classes}

\item{delta_s}{Numeric vector by \code{s}. Fraction of season that elapses when spawning occurs, e.g., midseason spawning when \code{delta_s = 0.5}.}

\item{natal_rs}{Matrix \verb{[r, s]}. The fraction of the mature stock \code{s} in region \code{r} that spawns at
time of spawning. See example in \linkS4class{Dstock}.}

\item{recdist_rs}{Matrix \verb{[r, s]}. The fraction of the incoming recruitment of stock \code{s} that settles in region \code{r}.}
}
\value{
A named list returned by \code{\link[=calc_population]{calc_population()}}.
}
\description{
Project a population forward in time using \code{\link[=calc_population]{calc_population()}} with constant recruitment and
seasonal dynamics (growth, movement-by-season) to obtain per recruit parameters. Note that the fishing
mortality among fleets and stocks remain linked by matrix \code{q_fs}.
}
\details{
The initial population vector will be the survival at age evenly divided by the number of regions \code{nr}.
}
\seealso{
\code{\link[=calc_phi_simple]{calc_phi_simple()}}
}
