% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{conv_Sigma}
\alias{conv_Sigma}
\title{Calculate covariance matrix}
\usage{
conv_Sigma(sigma, lower_diag)
}
\arguments{
\item{sigma}{Numeric vector of marginal standard deviations (all greater than zeros)}

\item{lower_diag}{Numeric vector to populate the lower triangle of the correlation matrix. All real numbers.
Length \code{sum(1:(length(sigma) - 1))}}
}
\value{
Numeric
}
\description{
Uses Cholesky factorization to generate a covariance matrix (or any symmetric positive definite matrix).
}
\examples{
set.seed(23)
n <- 5
sigma <- runif(n, 0, 2)
lower_diag <- runif(sum(1:(n-1)), -10, 10)
Sigma <- conv_Sigma(sigma, lower_diag)
Sigma/t(Sigma) # Is symmetric matrix? All ones
cov2cor(Sigma)

}
