% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{fit_MSA}
\alias{fit_MSA}
\title{Fit MSA model}
\usage{
fit_MSA(
  MSAdata,
  parameters,
  map = list(),
  random = NULL,
  run_model = TRUE,
  do_sd = TRUE,
  report = TRUE,
  silent = FALSE,
  control = list(iter.max = 2e+05, eval.max = 4e+05),
  ...
)
}
\arguments{
\item{MSAdata}{Data object. Class \linkS4class{MSAdata}, validated by \code{\link[=check_data]{check_data()}}}

\item{parameters}{List of parameters, e.g., returned by \code{\link[=make_parameters]{make_parameters()}} and validated by \code{\link[=check_parameters]{check_parameters()}}.}

\item{map}{List of parameters indicated whether they are fixed and how they are shared, e.g., returned by \code{\link[=make_parameters]{make_parameters()}}.
See \code{\link[RTMB:TMB-interface]{RTMB::MakeADFun()}}.}

\item{random}{Character vector indicating the parameters that are random effects, e.g., returned by \code{\link[=make_parameters]{make_parameters()}}.}

\item{run_model}{Logical, whether to fit the model through \code{\link[stats:nlminb]{stats::nlminb()}}.}

\item{do_sd}{Logical, whether to calculate the standard errors with \code{\link[RTMB:TMB-interface]{RTMB::sdreport()}}.}

\item{report}{Logical, whether to return the report list with \code{obj$report(obj$env$last.par.best)}.}

\item{silent}{Logical, whether to report progress to console. \strong{Not passed to \code{\link[TMB:MakeADFun]{TMB::MakeADFun()}}.} Recommend to set to \code{TRUE}
to speed up run time, e.g., when running simulations, multiple fits, etc.}

\item{control}{Passed to \code{\link[stats:nlminb]{stats::nlminb()}}}

\item{...}{Other arguments to \code{\link[RTMB:TMB-interface]{RTMB::MakeADFun()}}.}
}
\value{
A \linkS4class{MSAassess} object.
}
\description{
Wrapper function that calls RTMB to create the model and perform the numerical optimization
}
\seealso{
\code{\link[=report]{report()}} \code{\link[=retrospective]{retrospective()}}
}
