% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dat.R
\name{sim_dat}
\alias{sim_dat}
\title{Simulate data for optimizing scales of effect}
\usage{
sim_dat(
  alpha = 1,
  beta = NULL,
  kernel = c("gaussian", "exp", "expow", "fixed"),
  type = c("count", "count_nb", "occ", "gaussian"),
  StDev = 0.5,
  n_points = 50,
  min_D = NULL,
  raster_stack = NULL,
  sigma = NULL,
  shape = NULL,
  max_D = NULL,
  user_seed = NULL,
  ...
)
}
\arguments{
\item{alpha}{Intercept term for GLM (Default = 1)}

\item{beta}{Slope term(s) for GLM. Should be vector equal in length to number of spatRaster surfaces provided}

\item{kernel}{Type of kernel transformation. Valid options are 'gaussian', 'exp' (negative exponential), 'expow' (exponential power), and 'fixed' fixed width buffer. (Default = 'gaussian')}

\item{type}{Type of response data to simulate. Valid options are 'count' for Poisson distributed count; 'count_nb' for negative binomial counts; 'occ' for binomial response; and 'gaussian' for normally distributed response.
'count' for normally distributed response (Default = 'count')}

\item{StDev}{If specifying 'count_nb' or 'gaus' for type, this is the dispersion term for those respective processes (Default = 0.5)}

\item{n_points}{Number of spatial sample points (Default = 50). Alternatively, provide a spatVector point file.}

\item{min_D}{Minimum distance between points. Function will attempt to create the number of sample points specified while honoring this minimum distance.}

\item{raster_stack}{A spatRaster object}

\item{sigma}{The scale term dictating the rate of decay with distance}

\item{shape}{If using an exponential power function, the shape parameter must also be specified. Values between 1-50 are generally valid}

\item{max_D}{The maximum distance surrounding spatial points to consider. This typically needs to be >= 2.5x greater than sigma}

\item{user_seed}{Optional seed to reproduce simulation}

\item{...}{Additional arguments. Not currently used}
}
\value{
Returns a list containing:
\tabular{ll}{
\tab * obs --> The simulated response variable \cr
\tab * df --> A data frame with the simulated response (obs) as well as the true kernel weighted mean values for each raster surface included \cr
\tab * pts --> An `sf` object with the simulated spatial point locations \cr
  }
}
\description{
Function to simulate data with known scales of effect from spatial spatRaster variables
}
\details{
This function distributes sample points across the landscape on a hexagonal grid, then subsamples to the specified number. The weighted values of each landscape are determined according to the simulation parameters, then the specified response is generated.
}
\examples{
rs <- sim_rast()
rs <- terra::subset(rs, c(1,3))
s_dat <- sim_dat(alpha = 0.5,
                 beta = c(0.75,-0.75),
                 kernel = 'gaussian',
                 sigma = c(75, 150),
                 type = 'count',
                 raster_stack = rs,
                 max_D = 400)

plot(s_dat$df$y ~ s_dat$df$bin1)
plot(s_dat$df$y ~ s_dat$df$cont1)

}
