% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_transformations_binom.R
\name{tbinom_backtrans}
\alias{tbinom_backtrans}
\title{Backtransforms Samples From Real Line To Beta Parameters}
\usage{
tbinom_backtrans(xi_mat, boundaries, binom_equal, hyp_direction)
}
\arguments{
\item{xi_mat}{matrix with samples from truncated beta density. These samples should be transformed, so they range
over the entire real line}

\item{boundaries}{list containing indices for upper and lower truncation boundaries}

\item{binom_equal}{multiplicative elements for each lower and upper bound of each inequality constrained parameter.}

\item{hyp_direction}{specifies whether the imposed inequality constrained imposes an increasing (i.e., 'smaller') or
decreasing (i.e., 'larger') trend}
}
\value{
list consisting of the following elements:
(1) theta_mat: matrix with transformed samples
(2) lower_mat: matrix containing the lower bound for each parameter
(3) upper_mat: matrix containing the upper bound for each parameter
}
\description{
Transforms samples from the real line to samples from a truncated beta density using a stick-breaking algorithm.
This algorithm is suitable for mixtures of equality constrained parameters, inequality constrained parameters,
and free parameters
}
