% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ddsc.R
\name{plot_ddsc}
\alias{plot_ddsc}
\title{Plot deconstructed difference score correlation}
\usage{
plot_ddsc(
  ddsc_object,
  diff_color = "black",
  y1_color = "turquoise",
  y2_color = "orange",
  x_label = NULL,
  y_labels = NULL,
  densities = TRUE,
  point_alpha = 0.5,
  dens_alpha = 0.75,
  col_widths = c(3, 1),
  row_heights = c(2, 1, 0.5),
  coef_locations = c(0/3, 1/3, 2/3),
  coef_names = c("b_11", "b_21", "r_x_y1-y2"),
  coef_text_size = 4,
  y_scale = "standardized",
  x_scale = "scaled",
  show_dens_x_labels = TRUE
)
}
\arguments{
\item{ddsc_object}{An object produced by ddsc_sem function.}

\item{diff_color}{Character. Color for difference score (y1-y2). Default "black".}

\item{y1_color}{Character. Color for difference score component y1. Default "turquoise".}

\item{y2_color}{Character. Color for difference score component y2. Default "orange".}

\item{x_label}{Character. Label for variable X. If NULL (default), variable name is used.}

\item{y_labels}{Character vector. Labels for variable y1 and y2. If NULL (default), variable names are used.}

\item{densities}{Logical. Are y-variable densities plotted? Default TRUE.}

\item{point_alpha}{Numeric. Opacity for data points (default 0.50)}

\item{dens_alpha}{Numeric. Opacity for density distributions (default 0.75)}

\item{col_widths}{Numeric vector. Widths of the plot columns: slope figures and density figures; default c(3, 1).}

\item{row_heights}{Numeric vector. Heights of the plot rows: components, difference score, slope coefs; default c(2, 1, 0.5).}

\item{coef_locations}{Numeric vector. Locations for printed coefficients. Quantiles of the range of x-variable. Default c(0, 1/3, 2/3).}

\item{coef_names}{Character vector. Names of the printed coefficients. Default c("b_11", "b_21", "r_x_y1-y2").}

\item{coef_text_size}{Numeric. Text size of the printed coefficients. Default 4.}

\item{y_scale}{Character. "Scaled"/"standardized" with harmonized SD "raw" (original scale). Default is "standardized".}

\item{x_scale}{Character. "Standardized" or "raw" (original scale). Default is "standardized".}

\item{show_dens_x_labels}{Logical. Show x-labels on the density plots. Default TRUE.}
}
\description{
Plots the slopes for y1 and y2 by x, and a slope for y1-y2 by x for comparison.
}
\examples{
set.seed(342356)
d <- data.frame(
  y1 = rnorm(50),
  y2 = rnorm(50),
  x = rnorm(50)
)
fit<-ddsc_sem(
  data = d, y1 = "y1", y2 = "y2",
  x = "x"
)

plot_ddsc(fit,x_label = "X",
          y_labels=c("Y1","Y2"))

}
