% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference_plot.R
\name{inference_plot}
\alias{inference_plot}
\title{inference_plot}
\usage{
inference_plot(
  data,
  alpha_level = 0.05,
  add_line = TRUE,
  na.rm = FALSE,
  framework = "Both",
  col = c("gray45", "maroon4", "brown1"),
  return_plot = TRUE
)
}
\arguments{
\item{data}{a data frame with the results of a multiverse analysis}

\item{alpha_level}{What should be the alpha level used (default to 0.05)}

\item{add_line}{Whether to add a line with the alpha level in the produced histogram (default to \code{TRUE})}

\item{na.rm}{Should NA's be removed (default to \code{FALSE}). See details for more information}

\item{framework}{Inference framework. Values could be "NHST", "Bayesian", or "Both" (no case sensitivity)}

\item{col}{A length three vector with the colors to be used for ANOVAS, t-tests, and mixed models (in this order)}

\item{return_plot}{Whether to return a plot or not (default too TRUE)}
}
\value{
A histogram summarizing the results.
}
\description{
Function for plotting the multiverse results.
}
\details{
For the plot the NAs in the \code{p.value} column are removed automatically -- so what \code{ggplot2} does automatically but here no message is returned.

The \code{return_plot} argument is there in case you want to combine multiple panels and you do
not want to have a plot returned every time you run the code.
}
