% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.pivot_coord}
\alias{summary.pivot_coord}
\title{Create a Summary of a fitted \code{brmsfit} model from a \code{pivot_coord} object}
\usage{
\method{summary}{pivot_coord}(object, digits = 2, ...)
}
\arguments{
\item{object}{An object of class \code{pivot_coord}.}

\item{digits}{A integer value used for number formatting. Default is \code{2}.}

\item{...}{currently ignored.}
}
\value{
A data table of results.
}
\description{
Create a Summary of a fitted \code{brmsfit} model from a \code{pivot_coord} object
}
\examples{
\donttest{
if(requireNamespace("cmdstanr")){
  m <- brmcoda(complr = complr(data = mcompd, sbp = sbp,
                               parts = c("TST", "WAKE", "MVPA", "LPA", "SB"),
                               idvar = "ID", total = 1440),
  formula = Stress ~ bz1_1 + bz2_1 + bz3_1 + bz4_1 +
                     wz1_1 + wz2_1 + wz3_1 + wz4_1 + (1 | ID),
  chain = 1, iter = 500,
  backend = "cmdstanr")

  m_pc <- pivot_coord(m, method = "refit")
  summary(m_pc)
}}
}
