% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preproc-generics.R
\name{fit}
\alias{fit}
\title{Fit a preprocessing pipeline}
\usage{
fit(object, X, ...)
}
\arguments{
\item{object}{A preprocessing object (e.g., \code{prepper} or \code{pre_processor})}

\item{X}{A matrix or data frame to fit the preprocessing pipeline to}

\item{...}{Additional arguments passed to methods}
}
\value{
A fitted preprocessing object that can be used with \code{transform()} and \code{inverse_transform()}
}
\description{
Learn preprocessing parameters from training data. This function fits the
preprocessing pipeline to the provided data matrix, learning parameters
such as means, standard deviations, or other transformation parameters.
}
\examples{
# Fit a centering preprocessor
X <- matrix(rnorm(100), 10, 10)
preproc <- center()
fitted_preproc <- fit(preproc, X)

# Transform new data
X_new <- matrix(rnorm(50), 5, 10)
X_transformed <- transform(fitted_preproc, X_new)
}
\seealso{
\code{\link[=fit_transform]{fit_transform()}}, \code{\link[=transform]{transform()}}, \code{\link[=inverse_transform]{inverse_transform()}}
}
