% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{measure_interblock_transfer_error}
\alias{measure_interblock_transfer_error}
\title{Compute inter-block transfer error metrics for a cross_projector}
\usage{
measure_interblock_transfer_error(Xtrue, Ytrue, model, metrics = c("x2y.mse"))
}
\arguments{
\item{Xtrue}{The X block test data}

\item{Ytrue}{The Y block test data}

\item{model}{The fitted \code{cross_projector}}

\item{metrics}{A character vector like \code{c("x2y.mse","y2x.r2")}}
}
\value{
A 1-row tibble with columns for each requested metric
}
\description{
We measure how well the model can transfer from X->Y or Y->X, e.g. "x2y.mse".
}
\details{
The metric names are of the form "x2y.mse", "x2y.rmse", "y2x.r2", etc.
}
