% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preproc-generics.R
\name{preprocess}
\alias{preprocess}
\title{Convenience function for preprocessing workflow}
\usage{
preprocess(preproc, X, ...)
}
\arguments{
\item{preproc}{A preprocessing object (e.g., created with \code{center()}, \code{standardize()}, etc.)}

\item{X}{A matrix or data frame to preprocess}

\item{...}{Additional arguments passed to methods}
}
\value{
A list with two elements:
\item{preproc}{The fitted preprocessing object}
\item{transformed}{The transformed data matrix}
}
\description{
This helper function provides a simple interface for the common preprocessing
workflow: fit a preprocessor to data and return both the fitted preprocessor
and the transformed data.
}
\examples{
# Simple preprocessing workflow
X <- matrix(rnorm(100), 10, 10)
result <- preprocess(center(), X)
fitted_preproc <- result$preproc
X_centered <- result$transformed

# Equivalent to:
# fitted_preproc <- fit(center(), X)
# X_centered <- transform(fitted_preproc, X)
}
\seealso{
\code{\link[=fit]{fit()}}, \code{\link[=fit_transform]{fit_transform()}}, \code{\link[=transform]{transform()}}, \code{\link[=inverse_transform]{inverse_transform()}}
}
