% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-math.R
\name{dual-math}
\alias{dual-math}
\alias{Math,dualr-method}
\alias{exp,dualr-method}
\alias{sqrt,dualr-method}
\title{Math group generic for dual numbers}
\usage{
\S4method{exp}{dualr}(x)

\S4method{sqrt}{dualr}(x)

\S4method{Math}{dualr}(x)
}
\arguments{
\item{x}{A \code{dual} number.}
}
\value{
A \code{dual} with the function applied to the value and the
derivative propagated via the chain rule.
}
\description{
Implements all standard mathematical functions for dual numbers via
the chain rule: \code{f(dual(a, b)) = dual(f(a), df(a) * b)}.

Supported functions: \code{abs}, \code{sign}, \code{sqrt}, \code{floor},
\code{ceiling}, \code{trunc}, \code{round},
\code{exp}, \code{expm1}, \code{log}, \code{log2}, \code{log10}, \code{log1p},
\code{cos}, \code{sin}, \code{tan}, \code{cospi}, \code{sinpi}, \code{tanpi},
\code{acos}, \code{asin}, \code{atan},
\code{cosh}, \code{sinh}, \code{tanh}, \code{acosh}, \code{asinh}, \code{atanh},
\code{gamma}, \code{lgamma}, \code{digamma}, \code{trigamma},
\code{cumsum}, \code{factorial}, \code{lfactorial}.
}
\examples{
x <- dual_variable(pi / 4)
value(sin(x))
deriv(sin(x))

y <- dual_variable(2)
value(exp(y))
deriv(exp(y))
deriv(log(y))

}
