% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivatives.R
\name{jacobian}
\alias{jacobian}
\title{Compute the Jacobian of a vector-valued function}
\usage{
jacobian(f, x)
}
\arguments{
\item{f}{A function taking a parameter vector and returning a scalar,
list of scalars, or a \code{dual_vector}.}

\item{x}{A numeric vector of parameter values (length \code{p}).}
}
\value{
An \code{m x p} numeric matrix for vector-valued \code{f}, or
a numeric vector of length \code{p} for scalar-valued \code{f}.
}
\description{
Computes the first derivative of \code{f} at \code{x} using forward-mode
AD. Equivalent to \code{D(f, x)}. For \code{f: R^p -> R^m}, returns an
\code{m x p} matrix. For scalar-valued \code{f}, returns a length-p
gradient vector.
}
\examples{
f <- function(x) {
  a <- x[1]; b <- x[2]
  list(a * b, a^2, sin(b))
}
jacobian(f, c(2, pi/4))

g <- function(x) x[1]^2 + x[2]^2
jacobian(g, c(3, 4))
}
