% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density_learners.R
\name{lnr_glm_density}
\alias{lnr_glm_density}
\title{Conditional Normal Density Estimation Given Mean Predictors — with GLMs}
\usage{
lnr_glm_density(data, formula, weights = NULL, ...)
}
\arguments{
\item{data}{A dataframe to train a learner / learners on.}

\item{formula}{A regression formula to use inside this learner.}

\item{weights}{Observation weights; see \code{?lm}}

\item{...}{Any extra arguments that should be passed to the internal model
for model fitting purposes.}
}
\value{
a closure (function) that produces density estimates
at the \code{newdata} given according to the fit model.
}
\description{
This is a step up from the \code{lnr_lm_density} in that it uses
a \code{glm} for the conditional mean model.
Note that this allows for specification of \code{glm} features
like \code{family = ...} in the \code{,..} arguments, and
that's the main advantage over the \code{lnr_lm_density}.
Also note that this still differs from using \code{lnr_homoskedastic_density}
with \code{mean_lnr = lnr_glm} because \code{lnr_homoscedastic_density}
uses \code{stats::density} to do kernel bandwidth smoothing
on the error distribution of the mean predictions..
}
\examples{

# for example, we could use a Poisson assumption with identity link:

lnr_glm_density(mtcars, hp ~ mpg, family = poisson(link = 'identity'))(mtcars)
hp_seq <- seq(min(mtcars$hp), max(mtcars$hp), length.out = 1000)
plot(
  x = hp_seq,
  y = lnr_glm_density(mtcars, hp ~ mpg, family = poisson(link = 'identity'))(
    data.frame(hp = hp_seq, mpg = rep(mean(mtcars$mpg), 1000))),
  xlab = 'hp',
  ylab = 'density',
  main = 'normal density model of horsepower given mean(mpg)')

}
