% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learners.R
\name{lnr_hal}
\alias{lnr_hal}
\title{Highly Adaptive Lasso}
\usage{
lnr_hal(data, formula, weights = NULL, lambda = NULL, ...)
}
\arguments{
\item{data}{A dataframe to train a learner / learners on.}

\item{formula}{A regression formula to use inside this learner.}

\item{weights}{Observation weights; see \code{?lm}}

\item{lambda}{The multiplier parameter for the penalty; see \code{?glmnet::glmnet}}

\item{...}{Any extra arguments that should be passed to the internal model
for model fitting purposes.}
}
\value{
A prediction function that accepts \code{newdata},
which returns predictions (a numeric vector of values, one for each row
of \code{newdata}).
}
\description{
Highly Adaptive Lasso
}
\examples{
suppressWarnings({
# hal prints a lot of messages about some threads not reaching convergence
lnr_hal(mtcars, mpg ~ hp)(mtcars)
})
}
\seealso{
learners
}
