% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{get_team_info}
\alias{get_team_info}
\title{Get Team Info with Smart Matching}
\usage{
get_team_info(team, series = "all", type = "summary", interactive = TRUE)
}
\arguments{
\item{team}{Character string of the team name to search for.
Supports partial names and common misspellings
(e.g., \code{"gibbs"} finds Joe Gibbs Racing).}

\item{series}{Character string (\code{"cup"}, \code{"nxs"}, \code{"truck"},
\code{"all"}) or a pre-loaded data frame. Default is \code{"all"}.}

\item{type}{Character string specifying the return format:
\describe{
\item{\code{"summary"}}{Career totals grouped by series
(Seasons, Career Races, # of Drivers, Wins,
Best Finish, Avg Finish, Laps Raced, Laps Led).}
\item{\code{"season"}}{Season-by-season breakdown
(Races, # of Drivers, Wins, Best Finish, Avg Finish,
Laps Raced, Laps Led).}
\item{\code{"all"}}{Complete race-by-race results.}
}}

\item{interactive}{Logical. When \code{TRUE} (default) and the R
session is interactive, prompts the user to select from
multiple matches. When \code{FALSE}, silently uses the first
match.}
}
\value{
A tibble of team statistics (format depends on
\code{type}), or \code{invisible(NULL)} if no match is found.
}
\description{
Search for a team by name and return performance statistics.
Supports partial names, typos, and case-insensitive input
via the built-in fuzzy matching engine.
}
\examples{
\donttest{
# Career summary across all series
get_team_info("Joe Gibbs Racing")

# Season-by-season Cup data
get_team_info(
  "Joe Gibbs Racing",
  series = "cup",
  type = "season"
)
}
}
\seealso{
\code{\link[=get_driver_info]{get_driver_info()}}, \code{\link[=get_manufacturer_info]{get_manufacturer_info()}},
\code{\link[=load_series]{load_series()}}, \link{series_data}
}
