% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/james_taeuber.R
\name{james_taeuber}
\alias{james_taeuber}
\title{Dissimilarity Index based on James & Taeuber (1985)}
\usage{
james_taeuber(
  geo_large = "county",
  geo_small = "tract",
  year = 2020,
  subgroup,
  omit_NAs = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{geo_large}{Character string specifying the larger geographical unit of the data. The default is counties \code{geo_large = 'county'}.}

\item{geo_small}{Character string specifying the smaller geographical unit of the data. The default is census tracts \code{geo_small = 'tract'}.}

\item{year}{Numeric. The year to compute the estimate. The default is 2020, and the years 2009 onward are currently available.}

\item{subgroup}{Character string specifying the racial or ethnic subgroup(s) as the comparison population. See Details for available choices.}

\item{omit_NAs}{Logical. If FALSE, will compute index for a larger geographical unit only if all of its smaller geographical units have values. The default is TRUE.}

\item{quiet}{Logical. If TRUE, will display messages about potential missing census information. The default is FALSE.}

\item{...}{Arguments passed to \code{\link[tidycensus]{get_acs}} to select state, county, and other arguments for census characteristics}
}
\value{
An object of class 'list'. This is a named list with the following components:

\describe{
\item{\code{d}}{An object of class 'tbl' for the GEOID, name, and \emph{D} at specified larger census geographies.}
\item{\code{d_data}}{An object of class 'tbl' for the raw census values at specified smaller census geographies.}
\item{\code{missing}}{An object of class 'tbl' of the count and proportion of missingness for each census variable used to compute \emph{D}.}
}
}
\description{
Compute the aspatial Dissimilarity Index (James & Taeuber) of selected racial or ethnic subgroup(s) and U.S. geographies
}
\details{
This function will compute the aspatial Dissimilarity Index (\emph{D}) of selected racial or ethnic subgroups and U.S. geographies for a specified geographical extent (e.g., the entire U.S. or a single state) based on James & Taeuber (1985) \doi{10.2307/270845}. This function provides the computation of \emph{D} for any of the U.S. Census Bureau race or ethnicity subgroups (including Hispanic and non-Hispanic individuals).

The function uses the \code{\link[tidycensus]{get_acs}} function to obtain U.S. Census Bureau 5-year American Community Survey characteristics used for the aspatial computation. The yearly estimates are available for 2009 onward when ACS-5 data are available (2010 onward for \code{geo_large = 'cbsa'} and 2011 onward for \code{geo_large = 'place'}, \code{geo_large = 'csa'}, or \code{geo_large = 'metro'}) but may be available from other U.S. Census Bureau surveys. The twenty racial or ethnic subgroups (U.S. Census Bureau definitions) are:
\itemize{
\item \strong{B03002_002}: not Hispanic or Latino \code{'NHoL'}
\item \strong{B03002_003}: not Hispanic or Latino, white alone \code{'NHoLW'}
\item \strong{B03002_004}: not Hispanic or Latino, Black or African American alone \code{'NHoLB'}
\item \strong{B03002_005}: not Hispanic or Latino, American Indian and Alaska Native alone \code{'NHoLAIAN'}
\item \strong{B03002_006}: not Hispanic or Latino, Asian alone \code{'NHoLA'}
\item \strong{B03002_007}: not Hispanic or Latino, Native Hawaiian and Other Pacific Islander alone \code{'NHoLNHOPI'}
\item \strong{B03002_008}: not Hispanic or Latino, Some other race alone \code{'NHoLSOR'}
\item \strong{B03002_009}: not Hispanic or Latino, Two or more races \code{'NHoLTOMR'}
\item \strong{B03002_010}: not Hispanic or Latino, Two races including Some other race \code{'NHoLTRiSOR'}
\item \strong{B03002_011}: not Hispanic or Latino, Two races excluding Some other race, and three or more races \code{'NHoLTReSOR'}
\item \strong{B03002_012}: Hispanic or Latino \code{'HoL'}
\item \strong{B03002_013}: Hispanic or Latino, white alone \code{'HoLW'}
\item \strong{B03002_014}: Hispanic or Latino, Black or African American alone \code{'HoLB'}
\item \strong{B03002_015}: Hispanic or Latino, American Indian and Alaska Native alone \code{'HoLAIAN'}
\item \strong{B03002_016}: Hispanic or Latino, Asian alone \code{'HoLA'}
\item \strong{B03002_017}: Hispanic or Latino, Native Hawaiian and Other Pacific Islander alone \code{'HoLNHOPI'}
\item \strong{B03002_018}: Hispanic or Latino, Some other race alone \code{'HoLSOR'}
\item \strong{B03002_019}: Hispanic or Latino, Two or more races \code{'HoLTOMR'}
\item \strong{B03002_020}: Hispanic or Latino, Two races including Some other race \code{'HoLTRiSOR'}
\item \strong{B03002_021}: Hispanic or Latino, Two races excluding Some other race, and three or more races \code{'HoLTReSOR'}
}

Use the internal \code{state} and \code{county} arguments within the \code{\link[tidycensus]{get_acs}} function to specify geographic extent of the data output.

\emph{D} is a measure of the evenness of racial or ethnic residential segregation when comparing smaller geographical units to larger ones within which the smaller geographical units are located. \emph{D} can range in value from 0 to 1 and represents the proportion of racial or ethnic subgroup members that would have to change their area of residence to achieve an even distribution within the larger geographical area under conditions of maximum segregation.

Larger geographical units available include states \code{geo_large = 'state'}, counties \code{geo_large = 'county'}, census tracts \code{geo_large = 'tract'}, census-designated places \code{geo_large = 'place'}, core-based statistical areas \code{geo_large = 'cbsa'}, combined statistical areas \code{geo_large = 'csa'}, and metropolitan divisions \code{geo_large = 'metro'}. Smaller geographical units available include, counties \code{geo_small = 'county'}, census tracts \code{geo_small = 'tract'}, and census block groups \code{geo_small = 'cbg'}. If a larger geographical unit is comprised of only one smaller geographical unit (e.g., a U.S county contains only one census tract), then the \emph{D} value returned is NA. If the larger geographical unit is census-designated places \code{geo_large = 'place'}, core-based statistical areas \code{geo_large = 'cbsa'}, combined statistical areas \code{geo_large = 'csa'}, or metropolitan divisions \code{geo_large = 'metro'}, only the smaller geographical units completely within a larger geographical unit are considered in the \emph{D} computation (see internal \code{\link[sf]{st_within}} function for more information) and recommend specifying all states within which the interested larger geographical unit are located using the internal \code{state} argument to ensure all appropriate smaller geographical units are included in the \emph{D} computation.
}
\examples{
\dontrun{
# Wrapped in \dontrun{} because these examples require a Census API key.

  # Dissimilarity Index (James & Taeuber; a measure of evenness)
  ## of Black populations
  ## in census tracts within counties of Georgia, U.S.A. (2020)
  james_taeuber(
    geo_large = 'county',
    geo_small = 'tract',
    state = 'GA',
    year = 2020,
    subgroup = c('NHoLB', 'HoLB')
   )

}

}
\references{
James, D, & Taeuber, KE (1985) Measures of Segregation. \emph{Sociological Methodology}, 15:1-32. \doi{10.2307/270845}

Massey, DS, & Denton, NA (1988) The Dimensions of Residential Segregation. \emph{Social Forces}, 67(1):281-315. \doi{10.1093/sf/67.2.281}
}
\seealso{
\code{\link[tidycensus]{get_acs}} for additional arguments for geographic extent selection (i.e., \code{state} and \code{county}).

Other one-group evenness indices: \code{\link{atkinson}}, \code{\link{gini}}, \code{\link{sudano}}, \code{\link{theil}}

Between groups dissimilarity indices: \code{\link{duncan}}
}
