% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_adj_matrix.R
\name{get_adj_matrix}
\alias{get_adj_matrix}
\title{Generate adjacency matrix}
\usage{
get_adj_matrix(incM)
}
\arguments{
\item{incM}{a \code{logical} \code{matrix} containing the incidence matrix
with its column and row names (respectively, protein and peptide identifiers)
names and 0 or 1 values indicating whether or not the peptide maps on the
corresponding protein.}
}
\value{
a \code{numeric} \code{matrix} containing the adjacency matrix,
with value >0 or 0 indicating whether or not two proteins are identified by
shared peptide(s)
}
\description{
Generate an adjacency matrix representing protein-to-protein connections,
based on shared peptides. It is generated by cross product of the incidence
matrix of peptide-to-protein mappings.
}
\examples{
# Read the tab-delimited file containing he proteome incidence matrix
incM_filename <- system.file( "extdata"
                             , "incM_example"
                             , package = "net4pg"
                             , mustWork = TRUE)
rownames_filename <- system.file( "extdata"
                                  , "peptideIDs_incM_example"
                                  , package = "net4pg"
                                  , mustWork = TRUE)
colnames_filename <- system.file( "extdata"
                                 , "proteinIDs_incM_example"
                                 , package = "net4pg"
                                 , mustWork = TRUE)
incM <- read_inc_matrix(incM_filename=incM_filename
                 , colnames_filename=colnames_filename
                 , rownames_filename=rownames_filename)
# Only retain proteins with at least one shared peptide and all peptides
# mapping on such proteins.
incM_reduced <- reduce_inc_matrix(incM)
# Generate adjacency matrix describing protein-to-protein mappings
adjM <- get_adj_matrix(incM_reduced)

}
\author{
Laura Fancello
}
