% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_inc_matrix.R
\name{read_inc_matrix}
\alias{read_inc_matrix}
\title{Read incidence matrix of proteomic identifications}
\usage{
read_inc_matrix(incM_filename, colnames_filename, rownames_filename)
}
\arguments{
\item{incM_filename}{the name of the tab-delimited file containing incidence
matrix values; the input incidence matrix must contain along the columns
protein identifiers and along the rows peptides; each cell must contain a 1
or 0 value indicating whether or not the peptide maps on the corresponding
protein.}

\item{colnames_filename}{name of the file containing incidence matrix column
names, which are protein identifiers. The file must contain one identifier
per line. Protein identifiers must be in Ensembl format (i.e.,
ENSPXXXXXXXXXXX for human).}

\item{rownames_filename}{name of the file containing incidence matrix row
names, which are peptide identifiers. The file must contain one identifier
per line. Peptide identifiers can be in any format (i.e. numeric identifiers,
amino acid sequences, ...)}
}
\value{
a \code{logical} \code{matrix} containing the incidence matrix with
its column and row names (respectively, protein and peptide identifiers)
and 0 or 1 values indicating whether or not the peptide maps on the
corresponding protein.
}
\description{
Read in input the incidence matrix of peptide-to-protein mappings generated
from valid proteomic identifications.
}
\examples{
# Read the tab-delimited file containing he proteome incidence matrix
incM_filename <- system.file( "extdata"
                             , "incM_example"
                             , package = "net4pg"
                             , mustWork = TRUE)
rownames_filename <- system.file( "extdata"
                                  , "peptideIDs_incM_example"
                                  , package = "net4pg"
                                  , mustWork = TRUE)
colnames_filename <- system.file( "extdata"
                                 , "proteinIDs_incM_example"
                                 , package = "net4pg"
                                 , mustWork = TRUE)
incM <- read_inc_matrix(incM_filename = incM_filename
                 , colnames_filename = colnames_filename
                 , rownames_filename = rownames_filename)

}
\author{
Laura Fancello
}
