% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{paths}
\alias{paths}
\title{paths data frame}
\usage{
paths(a, top_n = 3, p_val = 0.05)
}
\arguments{
\item{a}{a netSEM object containing every variable}

\item{top_n}{an integer. How many paths from each variable should the function look at. Default value is 3.}

\item{p_val}{a numeric. The threshold below which a p-value is considered significant, and thus the path is considered valid. The default is 0.05, meaning that paths with p-values greater than 0.05 will not be considered significant. This parameter can be adjusted based on the specifics of your analysis.}
}
\value{
a data frame with two columns: Paths, containing the best paths through the netSEM as a string and min_R2 containing the smallest R2adj value between two variables in the path.
}
\description{
The function finds the best paths through netSEM modeling.
}
\details{
paths_analysis uses a recursive algorithm to rank all different paths through a netSEM model by the lowest R2adj in the pathway (the weakest link). Function returns the best paths in a data frame.
}
\examples{
\dontrun{
## Load the sample acrylic data set
data(acrylic)

## Run netSEM
ans <- netSEMp1(acrylic, "IrradTot", "YI")

path_data <- paths(ans, 3, 0.05)
}
}
