% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Senn2013.R
\docType{data}
\name{Senn2013}
\alias{Senn2013}
\title{Network meta-analysis in diabetes}
\format{
A data frame with the following columns:
\tabular{rl}{
\bold{\emph{TE}}\tab treatment effect \cr
\bold{\emph{seTE}}\tab standard error of treatment effect \cr
\bold{\emph{treat1}}\tab treatment 1 \cr
\bold{\emph{treat2}}\tab treatment 2 \cr
\bold{\emph{treat1.long}}\tab treatment 1 (full treatment names)
  \cr
\bold{\emph{treat2.long}}\tab treatment 2 (full treatment names)
  \cr
\bold{\emph{studlab}}\tab Study label
}
}
\source{
Senn S, Gavini F, Magrez D, Scheen A (2013):
Issues in performing a network meta-analysis.
\emph{Statistical Methods in Medical Research},
\bold{22}, 169--89
}
\description{
Network meta-analysis in diabetes comparing effects of a number of
drugs on the HbA1c value.

These data are used as an example in Senn et al. (2013) and have been
preprocessed for use in R package netmeta.
}
\details{
Treatment labels provided by columns \code{treat1} and
\code{treat2} have been abbreviated:
\itemize{
\item acar = Acarbose
\item benf = Benfluorex
\item metf = Metformin
\item migl = Miglitol
\item piog = Pioglitazone
\item plac = Placebo
\item rosi = Rosiglitazone
\item sita = Sitagliptin
\item sulf = Sulfonylurea
\item vild = Vildagliptin
}

Full treatment names are available in columns \code{treat1.long}
and \code{treat2.long}.
}
\examples{
data(Senn2013)
head(Senn2013)

# Example using netmeta():
# example(netmeta)
}
\seealso{
\code{\link{netmeta}}
}
\keyword{datasets}
