% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloading_tools.R
\name{download_nhd}
\alias{download_nhd}
\title{Download NHD}
\usage{
download_nhd(nhd_dir, hu_list, download_files = TRUE)
}
\arguments{
\item{nhd_dir}{character directory to save output into}

\item{hu_list}{character vector of hydrologic region(s) to download.
Use \link{get_huc} to find HU codes of interest. Accepts two digit
and four digit codes.}

\item{download_files}{boolean if FALSE, only URLs to files will be returned
can be hu02s and/or hu04s}
}
\value{
character Paths to geodatabases created.
}
\description{
Download NHD
}
\examples{
\donttest{
hu <- get_huc(sf::st_sfc(sf::st_point(c(-73, 42)), crs = 4326),
                            type = "huc08")

(hu <- substr(hu$huc8, 1, 2))

download_nhd(tempdir(), c(hu, "0203"), download_files = FALSE)
}
}
