% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Team.R
\name{team_week_schedule}
\alias{team_week_schedule}
\title{Access the schedule for a team and week since a date}
\usage{
team_week_schedule(team = 1, date = "now")
}
\arguments{
\item{team}{integer ID (e.g., 21), character full name (e.g., 'Colorado
Avalanche'), OR three-letter code (e.g., 'COL'); see \code{\link[=teams]{teams()}} for
reference; ID is preferable as there now exists duplicate three-letter codes
(i.e., 'UTA' for 'Utah Hockey Club' and 'Utah Mammoth')}

\item{date}{character in 'YYYY-MM-DD' (e.g., '2025-01-01'); see
\code{\link[=seasons]{seasons()}} for reference}
}
\value{
data.frame with one row per game
}
\description{
\code{team_week_schedule()} retrieves the schedule for a team and week since a date as a \code{data.frame} where each row represents game and includes detail on game timeline state, period/clock progression, and matchup flow, date/season filtering windows and chronological context, and team identity, affiliation, and matchup-side context.
}
\examples{
COL_schedule_Family_Week_2025 <- team_week_schedule(
  team = 21,
  date = '2025-10-06'
)
}
