% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runNestedApprox.R
\name{improveParamMarginals}
\alias{improveParamMarginals}
\title{Improve univariate parameter marginals using grid-based quadrature}
\usage{
improveParamMarginals(
  summary,
  nodes,
  nMarginalGrid = 5,
  nQuad,
  quadRule = "NULL",
  prune = -1,
  transform = "spectral"
)
}
\arguments{
\item{summary}{an approxSummary object, returned by \code{runNestedApprox}.}

\item{nodes}{parameter nodes to improve inference for. Specified as character (when using original scale) 
or integer (when using transformed scale), where the scale was specified in \code{runNestedApprox}.}

\item{nMarginalGrid}{number of grid points for marginal calculations. Default is 5.}

\item{nQuad}{number of AGHQ quadrature points. Default is 5 if d=2 and 3 otherwise.}

\item{quadRule}{quadrature rule to use for the parameter grid. Can be any of
\code{"AGHQ"}, \code{"CCD"}, \code{"AGHQSPARSE"} or \code{"USER"},
  the latter for user-defined grids, but standard use will be of \code{"AGHQ"}.}

\item{prune}{pruning parameter for removing AGHQ points at low-density points.}

\item{transform}{grid transformation method for internal AGHQ. Default is \code{"spectral"}.}
}
\value{
The modified \code{approxSummary} object with improved marginals.
}
\description{
Uses d-1 dimensional quadrature (by default AGHQ) to get improved univariate marginal estimates for parameters.
Users can select to apply to specific nodes of interest to limit computation.
}
\details{
See \code{runNestedApprox} for example usage.
}
