% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAR.R
\name{carBounds}
\alias{carBounds}
\title{Calculate bounds for the autocorrelation parameter of the \code{dcar_proper} distribution}
\usage{
carBounds(C, adj, num, M)
}
\arguments{
\item{C}{vector of the same length as \code{adj}, giving the normalized weights associated with each pair of neighboring locations.}

\item{adj}{vector of indices of the adjacent locations (neighbors) of each spatial location.  This is a sparse representation of the full adjacency matrix.}

\item{num}{vector giving the number of neighboring locations of each spatial location, with length equal to the number of locations.}

\item{M}{vector giving the diagonal elements of the conditional variance matrix, with length equal to the number of locations.}
}
\value{
A numeric vector containing the bounds (minimum and maximum allowable values) for the \code{gamma} parameter of the \code{dcar_proper} distribution.
}
\description{
Calculate the lower and upper bounds for the \code{gamma} parameter of the \code{dcar_proper} distribution
}
\details{
Bounds for gamma are the inverse of the minimum and maximum eigenvalues of: \eqn{M^(-0.5) C M^(0.5)}.  The lower and upper bounds are returned in a numeric vector.
}
\seealso{
\code{\link{CAR-Proper}}, \code{\link{carMinBound}}, \code{\link{carMaxBound}}
}
\author{
Daniel Turek
}
