% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pooled_nca.R
\name{run_pooled_nca}
\alias{run_pooled_nca}
\title{Performs non-compartmental analysis on pooled data}
\usage{
run_pooled_nca(
  dat,
  route = c("bolus", "oral", "infusion"),
  dose_type = c("first_dose", "repeated_doses", "combined_doses"),
  pooled = NULL,
  pooled_ctrl = pooled_control(),
  nca_ctrl = nca_control()
)
}
\arguments{
\item{dat}{A data frame containing raw time–concentration data in the
standard nlmixr2 format.}

\item{route}{Route of administration. Must be one of bolus, oral, or infusion.}

\item{dose_type}{Classified as first_dose, repeated_doses, or combined_doses
based on whether observed concentrations occur following the first
administration, during repeated dosing, or across both contexts.}

\item{pooled}{Optional pre-pooled data returned by \code{get_pooled_data}.}

\item{pooled_ctrl}{Optional list of control parameters used by \code{get_pooled_data()}
for pooling observations. Defaults to output from \code{pooled_control()}.}

\item{nca_ctrl}{List of options created by \code{nca_control} for NCA settings.}
}
\value{
A list containing NCA results according to the selected dose_type.
}
\description{
Implements pooled concentration–time profiling followed by non-compartmental
analysis (NCA) to derive pharmacokinetic parameters across single-dose, multiple-dose,
or combined dosing scenarios under bolus, oral, or infusion routes.
}
\details{
The function first pools individual subject data into representative
concentration–time profiles using \code{get_pooled_data} based on the settings in
\code{pooled_ctrl}. The pooled profiles are then passed to \code{getnca}, which computes
non-compartmental parameters using rules specified in \code{nca_ctrl}.
}
\examples{
out   <- processData(Bolus_1CPT)
dat   <- out$dat
route <- out$Datainfo$Value[out$Datainfo$Infometrics == "Dose Route"]

run_pooled_nca(
  dat       = dat,
  dose_type = "first_dose",
  route     = route
)$nca.fd.results

}
\seealso{
\code{\link{get_pooled_data}}, \code{\link{bin.time}}, \code{\link{getnca}}
}
\author{
Zhonghui Huang
}
